<?php
session_start();
$userid = $_SESSION['userid'];

if ($userid == NULL) {
?>
    <script type="text/javascript">
        window.location = "signin.php";
    </script>
<?php
    exit(); // Always exit after a redirect
}

$tid = $_SESSION['tid'];
$staffid = $_SESSION['staffid'];

include "header.php";
include "config.php"; // Assuming this connects to your database ($con should be available after this)

// Basic error checking for database connection
if (!$con) {
    die("Database connection failed: " . mysqli_connect_error());
}

date_default_timezone_set('Asia/Kolkata');
$now = new DateTime();
$logon = $now->format('Y-m-d H:i:s');

// --- INSERT into userlogs using Prepared Statement ---
$stmt_log = mysqli_prepare($con, "INSERT INTO userlogs (userid, staffid, tid, loginvia, loginon) VALUES (?, ?, ?, 'Web', ?)");
if ($stmt_log) {
    // 'iiis' -> i=integer, s=string. Assuming userid, staffid, tid are integers, logon is a string.
    mysqli_stmt_bind_param($stmt_log, "iiis", $userid, $staffid, $tid, $logon);
    mysqli_stmt_execute($stmt_log);
    mysqli_stmt_close($stmt_log);
} else {
    // Log error if statement preparation failed
    error_log("Failed to prepare userlogs insert statement: " . mysqli_error($con));
}

// --- Fetch user data using Prepared Statement ---
$col = null; // Initialize $col to null
$stmt_user = mysqli_prepare($con, "SELECT userid, uname, username, userpassword, usermobile, userbalance, useraccount, userifsc, userbank, branchname, useraddress, whatsapp, nameasbank FROM user WHERE userid = ?");
if ($stmt_user) {
    mysqli_stmt_bind_param($stmt_user, "i", $userid); // 'i' for integer userid
    mysqli_stmt_execute($stmt_user);
    $result_user = mysqli_stmt_get_result($stmt_user);
    $col = mysqli_fetch_assoc($result_user); // Using assoc for consistency and clarity
    mysqli_free_result($result_user);
    mysqli_stmt_close($stmt_user);
} else {
    // Critical error: cannot fetch user data
    die("Failed to prepare user select statement: " . mysqli_error($con));
}

// If user data couldn't be fetched (e.g., userid doesn't exist)
if ($col === null) {
    // Optionally redirect to signin or an error page
?>
    <script type="text/javascript">
        alert("User data not found. Please sign in again.");
        window.location = "signin.php";
    </script>
    <?php
    exit();
}


// --- PHP 8.0+ Polyfill for str_contains() ---
// This ensures the code works on PHP versions older than 8.0
if (!function_exists('str_contains')) {
    function str_contains(string $haystack, string $needle): bool
    {
        return '' === $needle || false !== strpos($haystack, $needle);
    }
}

// --- Helper Functions for Lucky Numbers (Start) ---

// Function to fetch the latest active lottery draw details using Prepared Statement
function getLatestLotteryDraw($con, $lotStatus) {
    $stmt = mysqli_prepare($con, "SELECT lotid, lotname, lotdate, lottime FROM lottery WHERE lotstatus = ? ORDER BY lotdate DESC, lottime DESC LIMIT 1");
    if (!$stmt) {
        error_log("Failed to prepare getLatestLotteryDraw statement: " . mysqli_error($con));
        return null;
    }
    mysqli_stmt_bind_param($stmt, "i", $lotStatus); // 'i' for integer lotStatus
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $data = null;
    if (mysqli_num_rows($result) > 0) {
        $data = mysqli_fetch_assoc($result);
    }
    mysqli_free_result($result);
    mysqli_stmt_close($stmt);
    return $data;
}

// Function to fetch ALL active tickets for a given lotid into an array for faster lookup using Prepared Statement
function getAllActiveLotticketsForDraw($con, $lotId) {
    $activeTickets = [];
    $stmt = mysqli_prepare($con, "SELECT ticketno FROM lotticket WHERE lotid = ? AND status = 1");
    if (!$stmt) {
        error_log("Failed to prepare getAllActiveLotticketsForDraw statement: " . mysqli_error($con));
        return [];
    }
    mysqli_stmt_bind_param($stmt, "i", $lotId); // 'i' for integer lotId
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    while ($row = mysqli_fetch_assoc($result)) {
        $activeTickets[] = $row['ticketno'];
    }
    mysqli_free_result($result);
    mysqli_stmt_close($stmt);
    return $activeTickets;
}

// Function to get lucky numbers based on provided criteria (now works with pre-fetched data)
function getLuckyNumbersOptimized($userBackupTickets, $userMobile, $activeLotticketsInDraw, $maxNumbers = 11) {
    $luckyNumbers = [];
    $existingNumbers = []; // To keep track of numbers already added

    // Step 1: Match last 3 digits of backupbuyticket.ticketno
    foreach ($userBackupTickets as $ticketNo) {
        if (count($luckyNumbers) >= $maxNumbers) break;
        $lastThreeDigits = substr($ticketNo, -3);

        foreach ($activeLotticketsInDraw as $lotticketNo) {
            // Using str_contains for LIKE '%$lastThreeDigits' behavior
            if (str_contains($lotticketNo, $lastThreeDigits) && !in_array($lotticketNo, $existingNumbers)) {
                $luckyNumbers[] = $lotticketNo;
                $existingNumbers[] = $lotticketNo;
                if (count($luckyNumbers) >= $maxNumbers) break 2; // Break outer loop too
            }
        }
    }

    // Step 2: Match any four digits of usermobile
    if (count($luckyNumbers) < $maxNumbers) {
        $mobileLength = strlen($userMobile);
        for ($i = 0; $i <= $mobileLength - 4; $i++) {
            if (count($luckyNumbers) >= $maxNumbers) break;
            $fourDigits = substr($userMobile, $i, 4);

            foreach ($activeLotticketsInDraw as $lotticketNo) {
                // Using str_contains for LIKE '%$fourDigits%' behavior
                if (str_contains($lotticketNo, $fourDigits) && !in_array($lotticketNo, $existingNumbers)) {
                    $luckyNumbers[] = $lotticketNo;
                    $existingNumbers[] = $lotticketNo;
                    if (count($luckyNumbers) >= $maxNumbers) break 2; // Break outer loop too
                }
            }
        }
    }

    // Step 3: Fill with random existing tickets from the active draw
    if (count($luckyNumbers) < $maxNumbers) {
        $availableForRandom = array_diff($activeLotticketsInDraw, $existingNumbers);
        shuffle($availableForRandom); // Randomize the remaining available tickets

        $needed = $maxNumbers - count($luckyNumbers);
        $randomlyAdded = array_slice($availableForRandom, 0, $needed);
        $luckyNumbers = array_merge($luckyNumbers, $randomlyAdded);
    }

    return $luckyNumbers;
}

// --- Helper Functions for Lucky Numbers (End) ---

// --- Data Pre-fetching for Lucky Numbers (Start) ---

// Fetch the latest daily and bumper draw information
$latestDailyDraw = getLatestLotteryDraw($con, 1); // lotstatus = 1 for daily
$latestBumperDraw = getLatestLotteryDraw($con, 2); // lotstatus = 2 for bumper

$allDailyLottickets = [];
if ($latestDailyDraw) {
    $allDailyLottickets = getAllActiveLotticketsForDraw($con, $latestDailyDraw['lotid']);
}

$allBumperLottickets = [];
if ($latestBumperDraw) {
    $allBumperLottickets = getAllActiveLotticketsForDraw($con, $latestBumperDraw['lotid']);
}

// Fetch current user's backup tickets using Prepared Statement
$currentUserBackupTickets = [];
$stmt_backup = mysqli_prepare($con, "SELECT ticketno FROM backupbuyticket WHERE userid = ?");
if ($stmt_backup) {
    mysqli_stmt_bind_param($stmt_backup, "i", $userid); // 'i' for integer userid
    mysqli_stmt_execute($stmt_backup);
    $result_backup = mysqli_stmt_get_result($stmt_backup);
    while ($backupRow = mysqli_fetch_assoc($result_backup)) {
        $currentUserBackupTickets[] = $backupRow['ticketno'];
    }
    mysqli_free_result($result_backup);
    mysqli_stmt_close($stmt_backup);
} else {
    error_log("Failed to prepare backupbuyticket select statement: " . mysqli_error($con));
}

// Calculate lucky numbers for the current user
$luckyNumbersDaily = [];
if ($latestDailyDraw) {
    $luckyNumbersDaily = getLuckyNumbersOptimized($currentUserBackupTickets, $col['usermobile'], $allDailyLottickets);
}

$luckyNumbersBumper = [];
if ($latestBumperDraw) {
    $luckyNumbersBumper = getLuckyNumbersOptimized($currentUserBackupTickets, $col['usermobile'], $allBumperLottickets);
}

// --- Data Pre-fetching for Lucky Numbers (End) ---

?>

<section class="w3l-breadcrumb">
    <div class="container">
        <ul class="breadcrumbs-custom-path">
            <li><a href="dashboard.php">Dashboard</a></li>
            <li><span class="fa fa-arrow-right mx-2" aria-hidden="true"></span> <a href="logout.php">Log-out</a></li>
        </ul>
    </div>
</section>

<style>
    body {
        background-color: #f0f2f5; /* Light grey background for the whole page */
        font-family: 'Open Sans', sans-serif; /* A clean, modern font */
    }

    /* General Card Styling */
    .grids-feature .area-box {
        background: #ffffff; /* White background for all general feature boxes */
        border: none;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1); /* Subtle shadow for depth */
        padding: 30px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%; /* Ensure consistent height within rows */
    }

    .grids-feature .area-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }

    .grids-feature .area-box h4 {
        font-weight: 600;
        margin-bottom: 15px;
        color: #333; /* Darker text for headings */
    }
    .grids-feature .area-box h4 a {
        color: #333;
        text-decoration: none;
    }
    .grids-feature .area-box h4 a:hover {
        color: #007bff; /* Primary blue on hover */
    }

    .grids-feature .area-box p {
        color: #555;
        line-height: 1.6;
        margin-bottom: 20px;
    }

    /* Buttons within feature boxes */
    .grids-feature .area-box .btn {
        font-weight: 600;
        border-radius: 8px;
        padding: 10px 20px;
        transition: background-color 0.3s ease, border-color 0.3s ease, color 0.3s ease;
    }

    /* Top Welcome Section Styling */
    .welcome-section {
        background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%); /* Same as lucky numbers section */
        color: white;
        padding: 60px 0;
        border-radius: 0 0 20px 20px; /* Rounded bottom corners */
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .welcome-section .title-big {
        font-size: 2.8em;
        font-weight: 700;
        margin-bottom: 10px;
        text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3);
    }
    .welcome-section p {
        font-size: 1.1em;
        opacity: 0.9;
    }

    /* Account Details Section Background */
    .account-details-section {
        background-color: #ffffff; /* White background */
        padding: 50px 0;
        margin-top: 30px;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    }
    .account-details-section .title-big {
        color: #333;
        font-weight: 600;
    }

    /* Tables within Account Details */
    .table-list-search {
        width: 100%;
        margin-bottom: 1rem;
        color: #444;
        font-size: 0.95em;
    }
    .table-list-search td {
        padding: 8px 0;
        border-bottom: 1px solid #eee;
    }
    .table-list-search tr:last-child td {
        border-bottom: none;
    }
    .table-list-search td:first-child {
        font-weight: 600;
        width: 40%;
    }
    .table-list-search a {
        color: #007bff;
        text-decoration: none;
    }
    .table-list-search a:hover {
        text-decoration: underline;
    }

    /* Lucky Number Section - Specific Overrides & Enhancements */
    .lucky-numbers-section {
        background: linear-gradient(to right, #6a11cb 0%, #2575fc 100%); /* Blue-purple gradient */
        padding: 40px 0;
        margin-top: 20px;
        color: white; /* Default text color for the section */
    }

    .lucky-numbers-section .card {
        border: none;
        border-radius: 15px;
        overflow: hidden; /* Ensures gradient fills card */
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        padding: 25px; /* Adjust padding for inner content */
    }

    .lucky-numbers-section .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
    }

    .lucky-numbers-section .card h4 {
        color: white; /* Headings white */
        margin-bottom: 20px;
        font-weight: 600;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
    }

    /* Specific background for Daily Card */
    .lucky-numbers-section .card.daily-card {
        background: linear-gradient(145deg, #FF7F50, #FF6347); /* Coral to Tomato (Warm) */
        color: white;
    }

    /* Specific background for Bumper Card */
    .lucky-numbers-section .card.bumper-card {
        background: linear-gradient(145deg, #4CAF50, #2E8B57); /* Green shades (Cool) */
        color: white;
    }

    .lucky-numbers-section .lucky-number-info {
        font-size: 0.95em;
        line-height: 1.6;
    }

    .lucky-numbers-section .lucky-number-info b {
        color: #ffeb3b; /* Yellow for "Lucky Numbers:" label */
        font-size: 1.1em;
    }

    .lucky-numbers-section .lucky-numbers-text {
        font-size: 1.8em; /* Larger font for the numbers */
        font-weight: bold;
        color: #f8e505; /* Bright yellow for the actual numbers */
        letter-spacing: 1px;
        display: block; /* Ensures it takes full width for clear display */
        margin-top: 10px;
        margin-bottom: 10px;
        text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5); /* Shadow for numbers */
    }

    .lucky-numbers-section .copy-content-btn {
        background-color: #f39c12; /* Orange for copy button */
        border-color: #e67e22;
        color: white;
        font-weight: bold;
        padding: 10px 25px;
        border-radius: 8px;
        transition: background-color 0.3s ease;
    }

    .lucky-numbers-section .copy-content-btn:hover {
        background-color: #e67e22;
        border-color: #d35400;
    }

    /* Responsive adjustments */
    @media (max-width: 767.98px) {
        .lucky-numbers-section .card,
        .grids-feature .area-box {
            padding: 20px;
        }
        .lucky-numbers-section .lucky-numbers-text {
            font-size: 1.5em;
        }
        .welcome-section .title-big {
            font-size: 2em;
        }
    }
</style>

<div class="lucky-numbers-section">
    <h3 class="title-big text-center mb-5" style="color:white;">Your Lucky Lottery Numbers!</h3>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100 daily-card">
                    <h4 class="text-center">Daily Draw Lucky Numbers</h4>
                    <div id="daily-lucky-display" class="lucky-number-info">
                        <?php
                        if ($latestDailyDraw) {
                            echo "<b>" . htmlspecialchars($latestDailyDraw['lotname']) . " : " . date('d-M-Y', strtotime($latestDailyDraw['lotdate'])) . " : " . date('h:i A', strtotime($latestDailyDraw['lottime'])) . "</b><br>";
                            echo "ONE SET COST 624<br>";
                            echo "TRANSFER TO OUR GPAY/PHONE PE/PAYTM 9567994816, 9167130160,<br>7900130160, 7506130160 AND BOOK YOUR TICKETS<br>";
                            if (!empty($luckyNumbersDaily)) {
                                echo "<b>Lucky Numbers:</b> <span class='lucky-numbers-text'>" . htmlspecialchars(implode(', ', $luckyNumbersDaily)) . "</span>";
                            } else {
                                echo "No daily lucky numbers found.";
                            }
                            echo "<div class='text-center mt-3'><button class='btn copy-content-btn' data-target-id='daily-lucky-display'>Copy All Daily Info</button></div>";
                        } else {
                            echo "<p class='text-muted'>No active daily draw found.</p>";
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card h-100 bumper-card">
                    <h4 class="text-center">Bumper Draw Lucky Numbers</h4>
                    <div id="bumper-lucky-display" class="lucky-number-info">
                        <?php
                        if ($latestBumperDraw) {
                            echo "<b>" . htmlspecialchars($latestBumperDraw['lotname']) . " : " . date('d-M-Y', strtotime($latestBumperDraw['lotdate'])) . " : " . date('h:i A', strtotime($latestBumperDraw['lottime'])) . "</b><br>";
                            echo "TRANSFER TO OUR GPAY/PHONE PE/PAYTM 9567994816, 9167130160,<br>7900130160, 7506130160 AND BOOK YOUR TICKETS<br>";
                            if (!empty($luckyNumbersBumper)) {
                                echo "<b>Lucky Numbers:</b> <span class='lucky-numbers-text'>" . htmlspecialchars(implode(', ', $luckyNumbersBumper)) . "</span>";
                            } else {
                                echo "No bumper lucky numbers found.";
                            }
                            echo "<div class='text-center mt-3'><button class='btn copy-content-btn' data-target-id='bumper-lucky-display'>Copy All Bumper Info</button></div>";
                        } else {
                            echo "<p class='text-muted'>No active bumper draw found.</p>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
---

<section class="welcome-section text-center">
    <div class="container py-lg-5 py-md-4">
        <h3 class="title-big mb-2" style="color:white;">Welcome <?php echo htmlspecialchars($col['uname']); ?></h3>
        <p style="color:yellow;">Contact details: <?php echo htmlspecialchars($col['usermobile']); ?></p>
        <br>
        <div class="grids-area-hny main-cont-wthree-fea row justify-content-center">
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="wallet.php" class="btn btn-info btn-lg btn-block">WALLET</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="selectlottery.php" class="btn btn-primary btn-lg btn-block">BUY TICKET</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="history.php" class="btn btn-info btn-lg btn-block">VIEW PURCHASED TICKET</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="updateprofile.php" class="btn btn-success btn-lg btn-block">UPDATE ADDRESS</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="withdrwal.php" class="btn btn-danger btn-lg btn-block">WITHDRAWAL</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <p><a href="qrpage.php" target="_blank" class="btn btn-warning btn-lg btn-block">ADD MONEY TO WALLET</a></p>
                </div>
            </div>
        </div>
    </div>
</section>

---

<section class="account-details-section text-center">
    <div class="container py-lg-5 py-md-4">
        <h3 class="title-big mb-2">Account Details</h3>
        <br>
        <div class="grids-area-hny main-cont-wthree-fea row">
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-address-card" style="font-size: 2.5em; color: #007bff; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Personal Details</a></h4>
                    <table class="table table-list-search">
                        <tr>
                            <td align="left">Name</td>
                            <td align="left"><?php echo htmlspecialchars($col['uname']); ?></td>
                        </tr>
                        <tr>
                            <td align="left">Contact No</td>
                            <td align="left"><?php echo htmlspecialchars($col['usermobile']); ?></td>
                        </tr>
                        <tr>
                            <td align="left">Whatsapp</td>
                            <td align="left"><?php echo htmlspecialchars($col['whatsapp']); ?></td>
                        </tr>
                        <tr>
                            <td align="left">Address</td>
                            <td align="left"><?php echo htmlspecialchars($col['useraddress']); ?></td>
                        </tr>
                    </table>
                    <p><a href="updateprofile.php" class="btn btn-primary">Update Profile</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-pencil-square-o" style="font-size: 2.5em; color: #28a745; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Bank Account Details</a></h4>
                    <table class="table table-list-search">
                        <tr>
                            <td align="left">Name (As per bank)</td>
                            <td align="left"><?php echo htmlspecialchars($col['nameasbank']); ?></td>
                        </tr>
                        <tr>
                            <td align="left">Account No</td>
                            <td align="left"><?php echo htmlspecialchars($col['useraccount']); ?></td>
                        </tr>
                    </table>
                    <p><a href="accountupdate.php" class="btn btn-primary">Update Bank Account </a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-key" style="font-size: 2.5em; color: #dc3545; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Update Password</a></h4>
                    <table class="table table-list-search">
                        <tr>
                            <td align="left">Username</td>
                            <td align="left"><?php echo htmlspecialchars($col['username']); ?></td>
                        </tr>
                        <tr>
                            <td align="left">Password</td>
                            <td align="left"><?php echo "********"; ?></td>
                        </tr>
                    </table>
                    <p><a href="updatepassword.php" class="btn btn-primary">Update Password</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-inr" style="font-size: 2.5em; color: #ffc107; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Wallet Details</a></h4>
                    <p>Available Balance : ₹ <?php echo htmlspecialchars($col['userbalance']); ?></p><br>
                    <p><a href="https://pinkysreya.com/product/checkout/?userid=<?php echo htmlentities($userid); ?>" target="_blank" class="btn btn-primary">Add Money</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-laptop" style="font-size: 2.5em; color: #17a2b8; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Help Desk</a></h4>
                    <p>"Need assistance? Our help desk is here to support you every step of the way."</p><br>
                    <p><a href="helpdesk.php" class="btn btn-primary">Help Desk</a></p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 grids-feature mb-4">
                <div class="area-box">
                    <span class="fa fa-balance-scale" style="font-size: 2.5em; color: #6f42c1; margin-bottom: 15px;"></span>
                    <h4><a href="#feature" class="title-head">Complaint</a></h4>
                    <p>To file a complaint or provide feedback, please click below button.</p>
                    <br>
                    <p><a href="complaint.php" class="btn btn-primary">Complaint</a></p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
include "footer.php";
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to copy text to clipboard and show feedback
        function copyToClipboard(text, elementForFeedback) {
            const tempTextArea = document.createElement('textarea');
            tempTextArea.value = text;
            document.body.appendChild(tempTextArea);
            tempTextArea.select();
            document.execCommand('copy');
            document.body.removeChild(tempTextArea);

            const originalText = elementForFeedback.innerText;
            elementForFeedback.innerText = 'Copied!';
            elementForFeedback.classList.add('btn-success'); // Add a success color class
            setTimeout(() => {
                elementForFeedback.innerText = originalText;
                elementForFeedback.classList.remove('btn-success'); // Remove the success color class
            }, 1500);
        }

        // Event listener for the "Copy All" buttons in the lucky numbers section
        document.querySelectorAll('.copy-content-btn').forEach(button => {
            button.addEventListener('click', function() {
                const targetId = this.getAttribute('data-target-id');
                const targetElement = document.getElementById(targetId);

                if (targetElement) {
                    const textToCopy = targetElement.innerText.trim();
                    copyToClipboard(textToCopy, this); // Pass 'this' (the button) for feedback
                }
            });
        });
    });
</script>