<?php
function openai_chat($messages, $model = 'gpt-4o-mini', $max_tokens = 350, $temperature = 0.6) {
    $apiKey = getenv('OPENAI_API_KEY');
    if (!$apiKey) {
        error_log("OPENAI_API_KEY missing");
        return null;
    }

    $url = "https://api.openai.com/v1/chat/completions"; // Chat Completions API
    // Docs: platform.openai.com/docs/api-reference/chat/create

    $payload = [
        "model" => $model,               // fast + cost-effective; use a larger model if you prefer
        "temperature" => $temperature,   // some variety without being chaotic
        "max_tokens" => $max_tokens,
        "messages" => $messages,
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Authorization: Bearer " . $apiKey
        ],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_TIMEOUT => 25
    ]);
    $raw = curl_exec($ch);
    if ($raw === false) {
        error_log("OpenAI curl error: " . curl_error($ch));
        curl_close($ch);
        return null;
    }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($code < 200 || $code >= 300) {
        error_log("OpenAI HTTP $code: $raw");
        return null;
    }

    $res = json_decode($raw, true);
    return $res["choices"][0]["message"]["content"] ?? null;
}
