<?php
    session_start();
    $userid = $_SESSION['userid'];

    if($userid == NULL) {
        ?>
        <script type="text/javascript">
            window.location = "index.php";
        </script>
        <?php
    }

    include "header.php";
    include "config.php";
    
    // Define the base URL where your images are stored on the superadmin domain
    $imageBaseUrl = "https://sa.pinkysreya.com/";

    // Fetch user details securely
    $stmt_user = $con->prepare("SELECT * FROM user WHERE userid = ?");
    $stmt_user->bind_param("i", $userid);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $col = $result_user->fetch_assoc();
    $stmt_user->close();
?>
<style>
    /* Added to ensure long lists of ticket numbers wrap nicely */
    .ticket-numbers-cell {
        word-break: break-word;
        white-space: normal;
    }

    /* === NEW CSS RULE ADDED HERE FOR THE BADGE === */
    .table .badge {
        padding: 0.6em 0.9em;      /* Increased padding to make the badge bigger */
        font-size: 0.9rem;         /* Slightly larger font size */
        color: #ffffff !important; /* Force font color to be white */
    }
</style>

<section class="w3l-breadcrumb">
    <div class="container">
        <ul class="breadcrumbs-custom-path">
            <li><a href="dashboard.php">Dashboard</a></li>
            <li class="active"><span class="fa fa-arrow-right mx-2" aria-hidden="true"></span>Courier Details</li>
        </ul>
    </div>
</section>

<div class="container">
    <p class="my-3">Welcome, <strong><?php echo htmlspecialchars($col['uname']); ?></strong> || Contact: <?php echo htmlspecialchars($col['usermobile']); ?></p>
    
</div>

<section class="w3l-download-main" style="background-color: white;">
    <div class="download-content text-center py-5" style="background-color: white;">
        <div class="container py-lg-4">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="table">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Lottery Name</th>
                            <th>Draw Date</th>
                            <th>Draw Time</th>
                            <th>Ticket No(s)</th>
                            <th>Buy Date</th>
                            <th>Courier Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            // ===================================================================
                            // === THIS IS THE NEW, UPDATED QUERY TO GROUP TICKETS TOGETHER ===
                            // ===================================================================
                            $stmt_tickets = $con->prepare("
                                SELECT
                                    lotname,
                                    lotdate,
                                    lottime,
                                    buydate,
                                    courier_status,
                                    GROUP_CONCAT(ticketno SEPARATOR ', ') AS ticket_numbers,
                                    MAX(courier_image_path) AS combined_image_path
                                FROM buyticket
                                WHERE
                                    userid = ? AND lotsize = 1
                                GROUP BY
                                    buydate, courier_status, lotname, lotdate, lottime
                                ORDER BY
                                    buydate DESC
                            ");
                            $stmt_tickets->bind_param("i", $userid);
                            $stmt_tickets->execute();
                            $ret = $stmt_tickets->get_result();
                            
                            $cnt=1;
                            if($ret->num_rows > 0){
                                while ($row = $ret->fetch_assoc()) {
                        ?>

                                <tr>
                                    <td><?php echo $cnt;?></td>
                                    <td><?php echo htmlspecialchars($row['lotname']);?></td>
                                    <td><?php echo htmlspecialchars($row['lotdate']);?></td>
                                    <td><?php echo htmlspecialchars($row['lottime']);?></td>
                                    <td class="ticket-numbers-cell"><?php echo htmlspecialchars($row['ticket_numbers']);?></td>
                                    <td><?php 
                                        $dbs = $row['buydate'];
                                        echo date("d-m-Y", strtotime($dbs));
                                    ?></td>
                                    <td>
                                        <?php
                                            $status = htmlspecialchars($row['courier_status']);
                                            $badge_class = 'badge-secondary'; // Default badge
                                            if ($status == 'Pending') { $badge_class = 'badge-warning'; }
                                            if ($status == 'Sent') { $badge_class = 'badge-success'; }
                                            if ($status == 'Locker') { $badge_class = 'badge-info'; }
                                        ?>
                                        <span class="badge <?php echo $badge_class; ?>"><?php echo $status; ?></span>
                                    </td>
                                    <td>
                                        <?php
                                            // Show download button based on the combined image path for the group
                                            if ($row['courier_status'] == 'Sent' && !empty($row['combined_image_path'])) {
                                                // We prepend the base URL to the path from the database
                                                $full_image_url = $imageBaseUrl . $row['combined_image_path'];
                                        ?>
                                            <a href="<?php echo htmlspecialchars($full_image_url); ?>" class="btn btn-success btn-sm" download>
                                                <i class="fas fa-download"></i> Download Image
                                            </a>
                                        <?php
                                            } else {
                                                echo "-"; // Show a dash if no action is available
                                            }
                                        ?>
                                    </td>
                                </tr>
                        <?php 
                                    $cnt=$cnt+1;
                                } 
                            } else { ?>
                                <tr>
                                    <th style="text-align:center; color:red;" colspan="8">No Courier Records Found</th>
                                </tr>
                            <?php } 
                            $stmt_tickets->close();
                        ?>
                    </tbody>
                </table>
            </div>
            <br>
            <br>
            <a href="prehistory.php">
                <button class="btn btn-primary btn-lg btn-block">View Previous Tickets</button>
            </a>
        </div>
    </div>
</section>

<?php 
    include "footer.php";
?>