<?php
session_start();
$userid = $_SESSION['userid'];




$tid = $_SESSION['tid'];
$staffid = $_SESSION['staffid'];

include "header.php";
include "config.php";

if (!$con) {
    die("Database connection failed: " . mysqli_connect_error());
}

date_default_timezone_set('Asia/Kolkata');
$now = new DateTime();
$logon = $now->format('Y-m-d H:i:s');

// Log user session
$stmt_log = mysqli_prepare($con, "INSERT INTO userlogs (userid, staffid, tid, loginvia, loginon) VALUES (?, ?, ?, 'Web', ?)");
if ($stmt_log) {
    mysqli_stmt_bind_param($stmt_log, "iiis", $userid, $staffid, $tid, $logon);
    mysqli_stmt_execute($stmt_log);
    mysqli_stmt_close($stmt_log);
}

// Fetch user info
$stmt_user = mysqli_prepare($con, "SELECT * FROM user WHERE userid = ?");
mysqli_stmt_bind_param($stmt_user, "i", $userid);
mysqli_stmt_execute($stmt_user);
$result_user = mysqli_stmt_get_result($stmt_user);
$col = mysqli_fetch_assoc($result_user);
mysqli_stmt_close($stmt_user);

if (!$col) {
    echo "<script>alert('User not found'); window.location='signin.php';</script>";
    exit();
}

// ---- Helper functions ----

// Get latest active lottery draw
function getCurrentLotteryDraw($con, $lotStatus)
{
    $stmt = mysqli_prepare($con, "
        SELECT lotid, lotname, lotdate, lottime 
        FROM lottery 
        WHERE lotstatus = ? 
        ORDER BY lottime ASC 
        LIMIT 1
    ");
    mysqli_stmt_bind_param($stmt, "i", $lotStatus);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($res);
    mysqli_stmt_close($stmt);
    return $data;
}

// Get all available tickets for a draw
function getAllActiveTickets($con, $lotid)
{
    $tickets = [];
    $stmt = mysqli_prepare($con, "SELECT ticketno FROM lotticket WHERE lotid = ? AND status = 1");
    mysqli_stmt_bind_param($stmt, "i", $lotid);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    while ($r = mysqli_fetch_assoc($res)) {
        $tickets[] = $r['ticketno'];
    }
    mysqli_stmt_close($stmt);
    return $tickets;
}

// Get user’s past (backup) tickets
function getUserBackupTickets($con, $userid)
{
    $tickets = [];
    $stmt = mysqli_prepare($con, "SELECT ticketno FROM backupbuyticket WHERE userid = ?");
    mysqli_stmt_bind_param($stmt, "i", $userid);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    while ($r = mysqli_fetch_assoc($res)) {
        $tickets[] = $r['ticketno'];
    }
    mysqli_stmt_close($stmt);
    return $tickets;
}

// Call OpenAI to generate lucky numbers
function getAIRecommendedNumbers($availableTickets, $userTickets, $lotteryName, $lotteryDate)
{
    if (!defined("OPENAI_API_KEY") || !OPENAI_API_KEY) {
        return "⚠️ OpenAI API Key not found.";
    }

    if (empty($availableTickets)) {
        return "No available tickets for this draw.";
    }

    $prompt = "
You are a helpful lottery analyst. Based on the user's previous ticket choices and the current available tickets,
suggest 5 lucky ticket numbers that might be interesting.

Lottery Name: $lotteryName
Draw Date: $lotteryDate

Available Tickets (sample): " . implode(', ', array_slice($availableTickets, 0, 250)) . "
User's Previous Tickets: " . implode(', ', array_slice($userTickets, 0, 100)) . "

Return exactly 5 numbers separated by commas. No extra words.
";

    $payload = [
        "model" => "gpt-4o-mini",
        "messages" => [
            ["role" => "system", "content" => "You are a helpful assistant that suggests possible lucky lottery numbers."],
            ["role" => "user", "content" => $prompt]
        ],
        "temperature" => 0.8,
        "max_tokens" => 120
    ];

    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer " . OPENAI_API_KEY
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    $response = curl_exec($ch);
if (curl_errno($ch)) {
    echo "<pre>cURL Error: " . curl_error($ch) . "</pre>";
}
curl_close($ch);

if (!$response) {
    return "⚠️ No response from OpenAI API.";
}

$result = json_decode($response, true);

if (isset($result['error'])) {
    return "⚠️ OpenAI API Error: " . $result['error']['message'];
}

    $result = json_decode($response, true); 
    return $result['choices'][0]['message']['content'] ?? "Unable to generate lucky numbers.";
}

// ---- Prepare data for AI ----
$latestDailyDraw  = getCurrentLotteryDraw($con, 1);
$latestBumperDraw = getCurrentLotteryDraw($con, 2);

$userTickets = getUserBackupTickets($con, $userid);

$luckyNumbersDaily = "";
$luckyNumbersBumper = "";

if ($latestDailyDraw) {
    $dailyTickets = getAllActiveTickets($con, $latestDailyDraw['lotid']);
    $luckyNumbersDaily = getAIRecommendedNumbers($dailyTickets, $userTickets, $latestDailyDraw['lotname'], $latestDailyDraw['lotdate']);
}
if ($latestBumperDraw) {
    $bumperTickets = getAllActiveTickets($con, $latestBumperDraw['lotid']);
    $luckyNumbersBumper = getAIRecommendedNumbers($bumperTickets, $userTickets, $latestBumperDraw['lotname'], $latestBumperDraw['lotdate']);
}
?>

<!-- Lucky Numbers Section -->
<div class="lucky-numbers-section" style="background: linear-gradient(to right,#6a11cb,#2575fc);padding:40px 0;color:white;">
  <div class="container text-center">
    <h3 class="title-big mb-5" style="color:white;">🎯 Your AI-Suggested Lucky Lottery Numbers</h3>
    <div class="row">
      <div class="col-md-6 mb-4">
        <div class="card p-4" style="background:linear-gradient(145deg,#FF7F50,#FF6347);color:white;border:none;border-radius:15px;">
          <h4>Daily Draw Lucky Numbers</h4>
          <?php
          if ($latestDailyDraw) {
              echo "<b>" . htmlspecialchars($latestDailyDraw['lotname']) . " (" . date('d-M-Y', strtotime($latestDailyDraw['lotdate'])) . ")</b><br><br>";
              echo nl2br(htmlspecialchars($luckyNumbersDaily));
          } else {
              echo "No active daily draw found.";
          }
          ?>
        </div>
      </div>

      <div class="col-md-6 mb-4">
        <div class="card p-4" style="background:linear-gradient(145deg,#4CAF50,#2E8B57);color:white;border:none;border-radius:15px;">
          <h4>Bumper Draw Lucky Numbers</h4>
          <?php
          if ($latestBumperDraw) {
              echo "<b>" . htmlspecialchars($latestBumperDraw['lotname']) . " (" . date('d-M-Y', strtotime($latestBumperDraw['lotdate'])) . ")</b><br><br>";
              echo nl2br(htmlspecialchars($luckyNumbersBumper));
          } else {
              echo "No active bumper draw found.";
          }
          ?>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Welcome Section -->
<section class="welcome-section text-center">
  <div class="container py-lg-5 py-md-4">
    <h3 class="title-big mb-2" style="color:white;">Welcome <?php echo htmlspecialchars($col['uname']); ?></h3>
    <p style="color:yellow;">Contact details: <?php echo htmlspecialchars($col['usermobile']); ?></p><br>

    <div class="grids-area-hny main-cont-wthree-fea row justify-content-center">
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="wallet.php" class="btn btn-info btn-lg btn-block">WALLET</a></p></div>
      </div>
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="selectlottery.php" class="btn btn-primary btn-lg btn-block">BUY TICKET</a></p></div>
      </div>
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="history.php" class="btn btn-info btn-lg btn-block">VIEW PURCHASED TICKET</a></p></div>
      </div>
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="updateprofile.php" class="btn btn-success btn-lg btn-block">UPDATE ADDRESS</a></p></div>
      </div>
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="withdrwal.php" class="btn btn-danger btn-lg btn-block">WITHDRAWAL</a></p></div>
      </div>
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box"><p><a href="qrpage.php" target="_blank" class="btn btn-warning btn-lg btn-block">ADD MONEY TO WALLET</a></p></div>
      </div>
    </div>
  </div>
</section>

<!-- Account Details -->
<section class="account-details-section text-center">
  <div class="container py-lg-5 py-md-4">
    <h3 class="title-big mb-2">Account Details</h3><br>

    <div class="grids-area-hny main-cont-wthree-fea row">
      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-address-card" style="font-size: 2.5em; color: #007bff;"></span>
          <h4>Personal Details</h4>
          <table class="table table-list-search">
            <tr><td>Name</td><td><?php echo htmlspecialchars($col['uname']); ?></td></tr>
            <tr><td>Contact No</td><td><?php echo htmlspecialchars($col['usermobile']); ?></td></tr>
            <tr><td>Whatsapp</td><td><?php echo htmlspecialchars($col['whatsapp']); ?></td></tr>
            <tr><td>Address</td><td><?php echo htmlspecialchars($col['useraddress']); ?></td></tr>
          </table>
          <p><a href="updateprofile.php" class="btn btn-primary">Update Profile</a></p>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-pencil-square-o" style="font-size: 2.5em; color: #28a745;"></span>
          <h4>Bank Account Details</h4>
          <table class="table table-list-search">
            <tr><td>Name (As per bank)</td><td><?php echo htmlspecialchars($col['nameasbank']); ?></td></tr>
            <tr><td>Account No</td><td><?php echo htmlspecialchars($col['useraccount']); ?></td></tr>
          </table>
          <p><a href="accountupdate.php" class="btn btn-primary">Update Bank Account</a></p>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-key" style="font-size: 2.5em; color: #dc3545;"></span>
          <h4>Update Password</h4>
          <table class="table table-list-search">
            <tr><td>Username</td><td><?php echo htmlspecialchars($col['username']); ?></td></tr>
            <tr><td>Password</td><td>********</td></tr>
          </table>
          <p><a href="updatepassword.php" class="btn btn-primary">Update Password</a></p>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-inr" style="font-size: 2.5em; color: #ffc107;"></span>
          <h4>Wallet Details</h4>
          <p>Available Balance : ₹ <?php echo htmlspecialchars($col['userbalance']); ?></p><br>
          <p><a href="https://pinkysreya.com/product/checkout/?userid=<?php echo htmlentities($userid); ?>" target="_blank" class="btn btn-primary">Add Money</a></p>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-laptop" style="font-size: 2.5em; color: #17a2b8;"></span>
          <h4>Help Desk</h4>
          <p>Need assistance? Our help desk is here to support you.</p>
          <p><a href="helpdesk.php" class="btn btn-primary">Help Desk</a></p>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 grids-feature mb-4">
        <div class="area-box">
          <span class="fa fa-balance-scale" style="font-size: 2.5em; color: #6f42c1;"></span>
          <h4>Complaint</h4>
          <p>To file a complaint or provide feedback, please click below.</p>
          <p><a href="complaint.php" class="btn btn-primary">Complaint</a></p>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include "footer.php"; ?>
