<?php
    session_start();
    $userid = $_SESSION['userid'];

    if($userid == NULL) {
        ?>
        <script type="text/javascript">
            window.location = "index.php";
        </script>
        <?php
    }

    include "header.php";
    include "config.php";
    
    // Define the base URL where your images are stored
    $imageBaseUrl = "https://sa.pinkysreya.com/";

    // Fetch user details securely
    $stmt_user = $con->prepare("SELECT * FROM user WHERE userid = ?");
    $stmt_user->bind_param("i", $userid);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $col = $result_user->fetch_assoc();
    $stmt_user->close();
?>
<section class="w3l-breadcrumb">
    <div class="container">
        <ul class="breadcrumbs-custom-path">
            <li><a href="dashboard.php">Dashboard</a></li>
            <li class="active"><span class="fa fa-arrow-right mx-2" aria-hidden="true"></span>Purchased Tickets</li>
        </ul>
    </div>
</section>

<div class="container">
    <p class="my-3">Welcome, <strong><?php echo htmlspecialchars($col['uname']); ?></strong> || Contact: <?php echo htmlspecialchars($col['usermobile']); ?></p>
</div>

<section class="w3l-download-main" style="background-color: white;">
    <div class="download-content text-center py-5" style="background-color: white;">
        <div class="container py-lg-4">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="table">
                    <thead>
                        <tr>
                            
                            <th>Lottery Name</th>
                            <th>Draw Date & Time</th>
                            
                            <th>Ticket No</th>
                            <th>Buy Date</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            // Securely fetch ticket data using prepared statements
                            $stmt_tickets = $con->prepare("SELECT * FROM buyticket WHERE userid = ? ORDER BY buyid DESC");
                            $stmt_tickets->bind_param("i", $userid);
                            $stmt_tickets->execute();
                            $ret = $stmt_tickets->get_result();
                            
                            $cnt=1;
                            if($ret->num_rows > 0){
                                while ($row = $ret->fetch_assoc()) {
                        ?>

                                <tr>
                                    
                                    <td><?php echo htmlspecialchars($row['lotname']);?></td>
                                    <td><?php echo htmlspecialchars($row['lotdate']);?> | <?php echo htmlspecialchars($row['lottime']);?></td>
                                    
                                    <td><?php echo htmlspecialchars($row['ticketno']);?></td>
                                    <td><?php 
                                        $dbs = $row['buydate'];
                                        echo date("d-m-Y", strtotime($dbs));
                                    ?></td>
                                   
                                    
                                </tr>
                        <?php 
                                $cnt=$cnt+1;
                                } 
                            } else { ?>
                                <tr>
                                    <th style="text-align:center; color:red;" colspan="8">No Records Found</th>
                                </tr>
                            <?php } 
                            $stmt_tickets->close();
                        ?>
                    </tbody>
                </table>
            </div>
            <br>
            <br>
            <a href="prehistory.php">
                <button class="btn btn-primary btn-lg btn-block">View Previous Tickets</button>
            </a>
        </div>
    </div>
</section>

<?php 
    include "footer.php";
?>